CREATE OR REPLACE FUNCTION MADGIS.PLAN_IFRAZ_CHECK(myid NUMBER) RETURN NUMBER
IS
ptype Number;
pno Varchar2(15);
gpno Varchar2(15);
prtno Varchar2(15);
gprtno Varchar2(15);
stno number;
n number;
muniq number;
muniq2 number;
p_obj SDO_GEOMETRY;
i_obj SDO_GEOMETRY;
c_obj SDO_GEOMETRY;
i2_obj SDO_GEOMETRY;
d_obj SDO_GEOMETRY;
p_area number;
carea number;
fff varchar2(200);
BEGIN


FOR row IN (SELECT PLANTYP,PLANNO,PARTNO FROM MADCAP.LNDT4700 WHERE ID=myid)
   LOOP
       
       ptype:= row.PLANTYP;
       pno:=  row.PLANNO;
       prtno:=  row.PARTNO;
       
       select GPLANNO into gpno from MADCAP.LNDT3010 where PLANTYP=ptype and PLANNO=pno;
       gprtno:=MADCAP.BREAK_PARTNO2(prtno,1);
       stno:= MADCAP.BREAK_PARTNO2(prtno,2);
       
       if nvl(stno,0)=0  then
         select count(*) into n from PARCEL where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno;
       else
         select count(*) into n from PARCEL where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno and STR_NO=stno;
       end if; 
       
       if n=0 then
        return 1;
       end if;
   
       if n>1 then
        return 1;
       end if;
    
       if nvl(stno,0)=0  then
         select d.GEOLOC into p_obj from PARCEL d where d.PLAN_NO=gpno and d.PLAN_TYPE=ptype and d.PARCELNO = gprtno;
       else
         select d.GEOLOC into p_obj from PARCEL d where d.PLAN_NO=gpno and d.PLAN_TYPE=ptype and d.PARCELNO = gprtno and STR_NO=stno;
       end if; 

   
   
   END LOOP;


FOR row IN (SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=myid)
   LOOP

       muniq:= row.UNIQUE_ID_4010;
       

       select count(*) into n from PARCEL_IFRAZ where PARCELCODE=muniq;
       
       if n=0 then
        return 2;
       end if;
    
       if n>1 then
        return 2;
       end if;
   
   
   END LOOP;

-- Checking Overlap each other
FOR row IN (SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=myid)
   LOOP
       muniq:= row.UNIQUE_ID_4010;
       --select  d.GEOLOC into i_obj from PARCEL_IFRAZ d where d.PARCELCODE=muniq;
       FOR row2 IN (SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=myid and UNIQUE_ID_4010<>muniq)
            LOOP
             muniq2:= row2.UNIQUE_ID_4010;
             --select  d.GEOLOC into i2_obj from PARCEL_IFRAZ d where d.PARCELCODE=muniq2;
             select  SDO_OVERLAPS(c.geoloc,d.geoloc) into fff from PARCEL_IFRAZ c,PARCEL_IFRAZ d where c.PARCELCODE=muniq and D.PARCELCODE=muniq2;         
             if fff='TRUE' then
                RETURN 3;
             END IF;   
      
            END LOOP;
      
   END LOOP;

--- All ifraz is combining
--SELECT sdo_aggr_union(sdoaggrtype(geoloc,0.00001)) into c_obj FROM PARCEL_IFRAZ where PARCELCODE in(SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=myid);
SELECT SDO_GEOM.VALIDATE_GEOMETRY_WITH_CONTEXT(sdo_aggr_union(sdoaggrtype(geoloc,0.00001)),0.005) into fff  FROM PARCEL_IFRAZ where PARCELCODE in(SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=myid);
--if SDO_GEOM.VALIDATE_GEOMETRY_WITH_CONTEXT(c_obj,0.00001)<>'TRUE' then
  if fff<>'TRUE' then
    return 4;
end if;

SELECT sdo_aggr_union(sdoaggrtype(geoloc,0.00001)) into c_obj FROM PARCEL_IFRAZ where PARCELCODE in(SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=myid);
d_obj:=SDO_GEOM.SDO_DIFFERENCE(p_obj,c_obj,0.0001);
p_area:=SDO_GEOM.SDO_AREA(d_obj,1,'unit=sq_m');

if p_area>0.2 then
    return 5;
end if;


d_obj:=SDO_GEOM.SDO_DIFFERENCE(c_obj,p_obj,0.0001);
p_area:=SDO_GEOM.SDO_AREA(d_obj,1,'unit=sq_m');

if p_area>0.2 then
    return 5;
end if;
  
return 0;
end;
/
